import React from "react";
import { useWindowDimensions } from "react-native";
import RenderHtml from "react-native-render-html";

const tagsStyles = {
	span: {
        color: '#FA886A',
        fontWeight: 'bold',
        fontFamily: "DMSans_700Bold",
	},
};

const DescParseHTML = ({ description }) => {
	const { width } = useWindowDimensions();
	const source = {
		html: description,
	};
	return (
		description && (
			<RenderHtml
				contentWidth={width}
				source={source}
				tagsStyles={tagsStyles}
			/>
		)
	);
};

export default DescParseHTML;